<?php
/**
 * Plugin Name:           AutomatorWP - HappyForms
 * Plugin URI:            https://automatorwp.com/add-ons/happyforms/
 * Description:           Connect AutomatorWP with HappyForms.
 * Version:               1.0.5
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-happyforms
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.4
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\HappyForms
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_HappyForms {

    /**
     * @var         AutomatorWP_HappyForms $instance The one true AutomatorWP_HappyForms
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_HappyForms self::$instance The one true AutomatorWP_HappyForms
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_HappyForms();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_HAPPYFORMS_VER', '1.0.5' );

        // Plugin file
        define( 'AUTOMATORWP_HAPPYFORMS_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_HAPPYFORMS_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_HAPPYFORMS_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Triggers
            require_once AUTOMATORWP_HAPPYFORMS_DIR . 'includes/triggers/submit-form.php';
            require_once AUTOMATORWP_HAPPYFORMS_DIR . 'includes/triggers/submit-field-value.php';
            // Anonymous Triggers
            require_once AUTOMATORWP_HAPPYFORMS_DIR . 'includes/triggers/anonymous-submit-form.php';
            require_once AUTOMATORWP_HAPPYFORMS_DIR . 'includes/triggers/anonymous-submit-field-value.php';

            // Includes
            require_once AUTOMATORWP_HAPPYFORMS_DIR . 'includes/functions.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'happyforms', array(
            'label' => 'HappyForms',
            'icon'  => AUTOMATORWP_HAPPYFORMS_URL . 'assets/happyforms.svg',
        ) );

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! function_exists( 'HappyForms' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_HappyForms instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_HappyForms The one true AutomatorWP_HappyForms
 */
function AutomatorWP_HappyForms() {
    return AutomatorWP_HappyForms::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_HappyForms' );
